

// make select mod
$("#selectMod").click(function(){
    canvas.isDrawingMode = false;
    document.getElementById('drawing-mode').innerHTML = 'Enter drawing mode';
	document.getElementById('drawing-mode-options').style.display = 'none';
});


createListenersKeyboard();
function createListenersKeyboard() {
    document.onkeydown = onKeyDownHandler;
    //document.onkeyup = onKeyUpHandler;
}


  function onKeyDownHandler(event) {
    //event.preventDefault();
    var key;
    if(window.event){
        key = window.event.keyCode;
    }
    else{
        key = event.keyCode;
    }
    
    switch(key){
        // Shortcuts
        case 67: // Ctrl+C
                if(event.ctrlKey){
                    event.preventDefault();
                    copy();
                }
            break;
        // Paste (Ctrl+V)
        case 86: // Ctrl+V
                if(event.ctrlKey){
                    event.preventDefault();
                    paste();
                }
            break;
        //delete (Delete)
        case 46: 
            {
                // alert(canvas.getActiveObject().layersActivatedKayId);
                // event.preventDefault();
                // DeleteBoject();
                DeleteLayers(canvas.getActiveObject().layersActivatedKayId);
            }
        break;
            
        default:
            // TODO
            break;
    }
}

// when click the canvas object the layer select automatically 
$( document ).ready(function() {
    // canvas.observe('mouse:down', function(){ 
    canvas.on('mouse:up', function (e) { 
        if(e.target !== null){
            console.log(e.target);
            $("li").removeClass("actived");
            $("#"+e.target.layersActivatedKayId).addClass("actived");
        }
    });
});

var copiedObject,
copiedObjects = new Array();
function copy(){
    copiedObjects = new Array();
    if(canvas.getActiveGroup()){
        //console.log(canvas.getActiveGroup().getObjects());
        canvas.getActiveGroup().getObjects().forEach(function(o){
            var object = fabric.util.object.clone(o);
            copiedObjects.push(object);
        });             
    }
    else if(canvas.getActiveObject()){
        var object = fabric.util.object.clone(canvas.getActiveObject());
        copiedObject = object;
        copiedObjects = new Array();
        
    }
}

function paste(){
    if(copiedObjects.length > 0){
        for(var i in copiedObjects){
        	copiedObjects[i]=fabric.util.object.clone(copiedObjects[i]);
			
            copiedObjects[i].set("top", copiedObjects[i].top+100);
            copiedObjects[i].set("left", copiedObjects[i].left+100);
            
            canvas.add(copiedObjects[i]);
            canvas.item(canvas.size() - 1).hasControls = true;
        }                
    }
    else if(copiedObject){
    	copiedObject= fabric.util.object.clone(copiedObject);
		copiedObject.set("top", 150);
    	copiedObject.set("left", 150);
        canvas.add(copiedObject);
        canvas.item(canvas.size() - 1).hasControls = true;
    }
    canvas.renderAll();  
}

function DeleteBoject() {
    canvas.getActiveObject().remove();
}

// PNG export local
var imageSaver = document.getElementById('lnkDownloadPNG');
imageSaver.addEventListener('click', saveImagePNG, false);

function saveImagePNG(e) {
    
    //var allCanvas = document.getElementsByTagName("canvas");
    
    var allCanvas = document.getElementById("canvas");
    
    // var Mainlayer = allCanvas.getContext("2d");
    
    // Mainlayer.clearRect(0, 0, 675, 500);
    
    this.href = allCanvas.toDataURL({
        format: 'png',
        quality: 0.8
    });
    this.download = 'Editor.png';
    // $.ajax({
    //     type: "POST",
    //     url: "savefinalImage.php",
    //     data: {str:this.href}					
    // });
}

// PJG export local
var imageSaver = document.getElementById('lnkDownloadJPG');
imageSaver.addEventListener('click', saveImageJPG, false);

function saveImageJPG(e) {
    
    this.href = canvas.toDataURL({
        format: 'jpg',
        quality: 0.8
    });
    this.download = 'Editor.jpg';
    //alert(this.href);
    $.ajax({
        type: "POST",
        url: "savefinalImage.php",
        data: {str:this.href}					
    });
}

// PDF export local
var imageSaver = document.getElementById('lnkDownloadPDF');
imageSaver.addEventListener('click', saveImagePDF, false);

function saveImagePDF(e) {
    
    this.href = canvas.toDataURL({
        format: 'png',
        quality: 0.8
    });
var imgData = this.href;
// imgData.target.blank;
var doc = new jsPDF();

doc.setFontSize(40);
doc.text(35, 25, 'Your Final Product');
doc.addImage(imgData, 'PNG', 15, 40, 180, 160);
doc.save('../Final_P_Images/Editor.pdf')
}

// save images for email send part
var imageSaver = document.getElementById('SaveImages');
imageSaver.addEventListener('click', saveImagePNGS, false);

function saveImagePNGS(e) {
    this.href = canvas.toDataURL({
        format: 'png',
        quality: 0.8
    });
    
    $.ajax({
        type: "POST",
        url: "savefinalImage.php",
        data: {str:this.href},
        success: function (data) {
             document.getElementById("img_val").value = data;
             //alert(data);
        }
    });
    
   
}


//layers checkbox function
function checkBox (x,id) {
    //alert(id);
    if (x.checked) {
        $(this).addClass("actived");
	   // var obj = canvas.item(id);
	   // canvas.setActiveObject(obj);				  
	    
	    canvas.getObjects().forEach(function(o) {
            if(o.layersActivatedKayId === id) {
                canvas.setActiveObject(o);
            }
        });
	    
	   // canvas.getActiveObject().set("top", 150);
	    canvas.getActiveObject().set("visible", true);
		canvas.renderAll();
	    
    } else {
        $(this).addClass("actived");
	   // var obj1 = canvas.item(id);
	   // canvas.setActiveObject(obj1);				  
	    
	   canvas.getObjects().forEach(function(o) {
            if(o.layersActivatedKayId === id) {
                canvas.setActiveObject(o);
            }
        }); 
	    
	   // canvas.getActiveObject().set("top", 1500);
	    canvas.getActiveObject().set("visible", false);
	    canvas.deactivateAll();
	    canvas.selection = false;
		canvas.renderAll();
    }
}


//delete Layers

function DeleteLayers (id) {
    // alert(id);
    // alert(canvas.getObjects().length);
    canvas.getObjects().forEach(function(o) {
        if(o.layersActivatedKayId === id) {
            canvas.setActiveObject(o);
        }
    });
    
    // var obj1 = canvas.item(id);
// 	canvas.setActiveObject(canvas.item(id));
	DeleteBoject();
	$("#layer"+id).hide();
	canvas.renderAll();
}

function topProp() {
    alert();
    canvas.getActiveObject().setTop(1000);
    canvas.renderAll();
}

//Zoom options
$(function(){
   
    $('#zoomIn').click(function(){
        canvas.setZoom(canvas.getZoom() * 1.1 );
    }) ;
    $('#zoomOut').click(function(){
        canvas.setZoom(canvas.getZoom() / 1.1 ) ;
    }) ;
    
    $('#goRight').click(function(){
        var units = 10 ;
        var delta = new fabric.Point(units,0) ;
        canvas.relativePan(delta) ;
    }) ;
    
    $('#goLeft').click(function(){
        var units = 10 ;
        var delta = new fabric.Point(-units,0) ;
        canvas.relativePan(delta) ;
    }) ;
    $('#goUp').click(function(){
        var units = 10 ;
        var delta = new fabric.Point(0,-units) ;
        canvas.relativePan(delta) ;
    }) ;
    
    $('#goDown').click(function(){
        var units = 10 ;
        var delta = new fabric.Point(0,units) ;
        canvas.relativePan(delta) ;
    }) ;
    
});
